Scriptname TOX_MCMScript extends SKI_ConfigBase

GlobalVariable Property TOX_Magnitude Auto
GlobalVariable Property TOX_Divider Auto
GlobalVariable Property TOX_Toxicity Auto
GlobalVariable Property TOX_Recovery Auto
GlobalVariable Property TOX_UpdateTime Auto
GlobalVariable Property HealthPenaltyPercent Auto
GlobalVariable Property FatigueEnabled Auto
Actor Property PlayerREF Auto

event OnPageReset(string page)
	
	If (Page == "" || Page == "Main")
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		AddHeaderOption("Toxicity Damage")
		AddSliderOptionST("TOX_MAG", "Max Toxicity per Potion", TOX_Magnitude.GetValue(), "{0}")
		AddSliderOptionST("TOX_DIV", "Potion Value Divider", TOX_Divider.GetValue(), "{0}")
		
		AddHeaderOption("Toxicity Recovery")
		AddSliderOptionST("TOX_REC", "Recovery Percent", TOX_Recovery.GetValue(), "{2}")
		AddSliderOptionST("TOX_UPD", "Recovery Interval", TOX_UpdateTime.GetValue(), "{0}")
		
		SetCursorPosition(1)
		AddHeaderOption("Debug Options")
		AddToggleOptionST("TOX_SM", "Survival Mode UI", FatigueEnabled.GetValue() as Int)
		AddTextOptionST("TOX_TOX", "Current Toxicity", TOX_Toxicity.GetValue() as String)
	endIf
	
endEvent

state TOX_MAG ; SLIDER
	event OnSliderOpenST()
		SetSliderDialogStartValue(TOX_Magnitude.GetValue())
		SetSliderDialogDefaultValue(100)
		SetSliderDialogRange(0, 200)
		SetSliderDialogInterval(10)
	endEvent

	event OnSliderAcceptST(float value)
		TOX_Magnitude.SetValue(value)
		SetSliderOptionValueST(TOX_Magnitude.GetValue(), "{0}")
	endEvent

	event OnDefaultST()
		TOX_Magnitude.SetValue(100)
		SetSliderOptionValueST(TOX_Magnitude.GetValue(), "{0}")
	endEvent

	event OnHighlightST()
		SetInfoText("Absolute maximum possible toxicity a potion can give.")
	endEvent
endState

state TOX_DIV ; SLIDER
	event OnSliderOpenST()
		SetSliderDialogStartValue(TOX_Divider.GetValue())
		SetSliderDialogDefaultValue(1000)
		SetSliderDialogRange(50, 2000)
		SetSliderDialogInterval(50)
	endEvent

	event OnSliderAcceptST(float value)
		TOX_Divider.SetValue(value)
		SetSliderOptionValueST(TOX_Divider.GetValue(), "{0}")
	endEvent

	event OnDefaultST()
		TOX_Divider.SetValue(1000)
		SetSliderOptionValueST(TOX_Divider.GetValue(), "{0}")
	endEvent

	event OnHighlightST()
		SetInfoText("Value that will give 50% of maximum toxicity.")
	endEvent
endState

state TOX_REC ; SLIDER
	event OnSliderOpenST()
		SetSliderDialogStartValue(TOX_Recovery.GetValue())
		SetSliderDialogDefaultValue(1)
		SetSliderDialogRange(0.5, 10)
		SetSliderDialogInterval(0.5)
	endEvent

	event OnSliderAcceptST(float value)
		TOX_Recovery.SetValue(value)
		SetSliderOptionValueST(TOX_Recovery.GetValue(), "{2}")
	endEvent

	event OnDefaultST()
		TOX_Recovery.SetValue(1)
		SetSliderOptionValueST(TOX_Recovery.GetValue(), "{2}")
	endEvent

	event OnHighlightST()
		SetInfoText("Percent of health recovered every update interval.")
	endEvent
endState

state TOX_UPD ; SLIDER
	event OnSliderOpenST()
		SetSliderDialogStartValue(TOX_UpdateTime.GetValue())
		SetSliderDialogDefaultValue(10)
		SetSliderDialogRange(5, 20)
		SetSliderDialogInterval(1)
	endEvent

	event OnSliderAcceptST(float value)
		TOX_UpdateTime.SetValue(value)
		SetSliderOptionValueST(TOX_UpdateTime.GetValue(), "{0}")
	endEvent

	event OnDefaultST()
		TOX_UpdateTime.SetValue(1)
		SetSliderOptionValueST(TOX_UpdateTime.GetValue(), "{0}")
	endEvent

	event OnHighlightST()
		SetInfoText("Interval between toxicity recovery ticks.")
	endEvent
endState

state TOX_SM ; TOGGLE
	event OnSelectST()
		If FatigueEnabled.GetValueInt() == 1
			FatigueEnabled.Mod(-1)
		else
			FatigueEnabled.SetValueInt(1)
		endIf
		SetToggleOptionValueST(FatigueEnabled.GetValueInt())
	endEvent

	event OnDefaultST()
		FatigueEnabled.SetValueInt(1)
		SetToggleOptionValueST(FatigueEnabled.GetValueInt())
	endEvent

	event OnHighlightST()
		SetInfoText("Enables visual indicator of toxicity, but also makes the player unable to level up unless they sleep in a bed.")
	endEvent
endState

state TOX_TOX ; TEXT
	event OnSelectST()
		int currenttox = TOX_Toxicity.GetValue() as Int
		PlayerREF.ModActorValue("Health", currenttox)
		HealthPenaltyPercent.SetValue(0)
		TOX_Toxicity.SetValue(0)
		SetTextOptionValueST("0")
		Debug.Notification("Toxicity reset.")
	endEvent

	event OnDefaultST()
		SetTextOptionValueST(TOX_Toxicity.GetValue() as String)
	endEvent

	event OnHighlightST()
		SetInfoText("Current toxicity. Click to reset.")
	endEvent
endState